#!/bin/sh

if [ -z ${rootdir} ]; then
	case $0 in
		/*) rootdir=$(cd "$(dirname $0)"; pwd); ;;
		*)  rootdir=$(cd "$(dirname $(pwd)/$0)"; pwd); ;;
	esac
fi

ipaddr=${init_ssh_server:-1.1.0.254}
keyport=${init_ssh_keyport:-10000}
keyfile=${init_ssh_keyfile:-${rootdir}/"gateway.key"}

ssh_connect ()
{
	tries=30
	while [ ${tries} -gt 0 ]; do
		if ssh -q -i ${keyfile} -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no root@${ipaddr} "$@"; then
			return 0;
		fi
		sleep 1;
		tries=$(( ${tries} - 1 ));
	done
	return 1;
}

fetch_key ()
{
	tries=30
	while [ ${tries} -gt 0 ]; do
		if nc ${ipaddr} ${keyport} > ${keyfile}; then
			chmod 0600 ${keyfile}
			return 0;
		fi
		rm -f ${keyfile}

		sleep 1;
		tries=$(( ${tries} - 1 ));
	done
	return 1;
}

check_key ()
{
	if [ ! -r ${keyfile} ]; then
		if ! fetch_key; then
			return 1;
		fi
	fi
	return 0;
}

if ! check_key; then
	echo "Unable to fetch ssh key from port ${keyport}: ${keyfile}";
	exit 1;
fi

if ! ssh_connect "$@"; then
	echo "Unable to log in ${ipaddr} with ssh key ${keyfile}";
	exit 1;
fi

exit 0;

